<?php
try {
    // Kiểm tra nếu tệp không được tải lên
    if (!isset($_FILES['file'])) {
        throw new Exception("No file uploaded.");
    }

    // Kiểm tra đường dẫn tương đối
    if (!isset($_POST['path']) || empty($_POST['path'])) {
        throw new Exception("Path missing.");
    }

    // Lấy đường dẫn tương đối và chuyển đổi dấu \
    $relativePath = str_replace("\\", "/", $_POST['path']);
    $targetPath = __DIR__ . '/' . $relativePath;

    // Tạo lại cây thư mục nếu chưa tồn tại
    $targetDir = dirname($targetPath);
    if (!file_exists($targetDir)) {
        mkdir($targetDir, 0777, true);
    }

    // Lưu tệp vào vị trí chính xác
    if (move_uploaded_file($_FILES['file']['tmp_name'], $targetPath)) {
        echo "File uploaded successfully: $relativePath";
    } else {
        throw new Exception("Failed to save uploaded file.");
    }
} catch (Exception $e) {
    echo "Error: " . $e->getMessage();
}
?>
