#version 330 core

in VS_OUT {
    vec2 uv;
    vec4 color;
} fs;

uniform sampler2D uTexture;
uniform int  uAlphaTestEnabled;   // 0/1
uniform float uAlphaRef;          // mặc định 0.5 (sửa theo CPU path)

out vec4 oColor;

void main(){
    vec4 tex = texture(uTexture, fs.uv);

    // Alpha Test giống fixed-pipeline (theo alpha texture)
    if (uAlphaTestEnabled == 1 && tex.a <= uAlphaRef)
        discard;

    // Fixed-pipeline MODULATE (texture * current color)
    oColor = vec4(tex.rgb * fs.color.rgb, tex.a * fs.color.a);
}
